(defun vlax-LW (lw / flw)
  (if (setq flw (distof lw))
    (progn
      (setq flw (fix (* flw 100)))
    (cond ((< flw 5) acLnWt000)
          ((< flw 9) acLnWt005)
          ((< flw 13) acLnWt009)
          ((< flw 15) acLnWt013)
          ((< flw 18) acLnWt015)
          ((< flw 20) acLnWt018)
          ((< flw 25) acLnWt020)
          ((< flw 30) acLnWt025)
          ((< flw 35) acLnWt030)
          ((< flw 40) acLnWt035)
	  ((< flw 50) acLnWt040)
          ((< flw 53) acLnWt050)
          ((< flw 60) acLnWt053)
          ((< flw 70) acLnWt060)
          ((< flw 80) acLnWt070)
          ((< flw 90) acLnWt080)
          ((< flw 100) acLnWt090)
          ((< flw 106) acLnWt100)
          ((< flw 120) acLnWt106)
          ((< flw 140) acLnWt120)
          ((< flw 158) acLnWt140)
          ((< flw 200) acLnWt158)
          ((< flw 211) acLnWt200)
          ((< flw 212) acLnWt211)
          (T acLnWtByLwDefault)))
    acLnWtByLayer))

(defun vlax-2d-point (pt)
  (vlax-make-variant (vlax-safearray-fill (vlax-make-safearray vlax-vbDouble '(0 . 1)) (list (car pt) (cadr pt)))))

(defun vlax->PutProperty  (object Cechy / tcol &)
  (ename->vlaObj 'object)
  (foreach &  Cechy
    (if (= (car &) 'Color)
      (cond ((= (type (cadr &)) 'STR)
             (if (distof (cadr &))
               (vlax-put-property object (car &) (atoi (cadr &)))
               (progn (setq tcol (_podziel_znak (cadr &) ","))
                      (if (and (= (length tcol) 3) (distof (nth 0 tcol)) (distof (nth 1 tcol)) (distof (nth 2 tcol)))
                        (SetTColor (vlax-vla-object->ename object) (atoi (nth 0 tcol)) (atoi (nth 1 tcol)) (atoi (nth 2 tcol)))))))
            ((= (type (cadr &)) 'INT) (vlax-put-property object (car &) (cadr &))))
      (if (vlax-property-available-p object (car &))
         (vlax-put-property object (car &) (cadr &))))))

(defun vlax->CopyProperty  (objTo objFrom Cechy / tr)
  (ename->vlaObj 'objTo)
  (ename->vlaObj 'objFrom)	
  (foreach &  Cechy
    (if (and (vlax-property-available-p objFrom &) (vlax-property-available-p objTo & T))
      (progn
        (if (and (= & 'Color)
                 (setq tr (vla-get-TrueColor objFrom)))
           (vla-put-TrueColor objTo tr)  
           (vlax-put-property objTo & (vlax-get-property objFrom &)))))))

(defun vlax->Property-GetValue (&Prop Cechy Def / res)
  (setq res Def)
  (foreach & Cechy
  (if (eq (car &) &Prop)
    (setq res (cadr &))))
  res)

(defun vlax-Collection->list  (collection / res xx)
  (setq res '())
  (vlax-for xx collection (setq res (append res (list xx))))
  res)

(defun vlax->Layer (name) (vla-item (vla-get-layers #acadDoc) name))

(defun getTextInsertionPoint  (object / e)
  (ename->vlaObj 'object)
  (if (= (vla-get-ObjectName object) "AcDbMText")
    (vlax-safearray->list (vlax-variant-value (vla-get-InsertionPoint object)))
    (cond ((or #GSTAR #Toolkit)
           (setq e (entget (vlax-vla-object->ename object)))
           (if (= (casc 72 e) 0)
             (casc 10 e)
             (casc 11 e)))
          (T
           (vlax-safearray->list
             (vlax-variant-value
               (cond ((eq (vla-get-Alignment object) acAlignmentLeft) (vla-get-InsertionPoint object))
                     (T (vla-get-TextAlignmentPoint object)))))))))


(defun msg-vla-put-TextInsertionPoint  (object punkt)
  (ename->vlaObj 'object)
  (cond ((eq (vla-get-Alignment object) acAlignmentLeft)
         (vla-put-InsertionPoint object (vlax-3d-point punkt)))
        (T (vla-put-TextAlignmentPoint object (vlax-3d-point punkt))))
  (vla-update object))

(defun ListaWarstw  (/ layers Name xx)
  (setq layers '())
  (if #Toolkit
    (progn (vlax-for xx  (vla-get-layers #acadDoc)
             (setq Name (vla-get-Name xx))
             (if (null (wcmatch Name "*$*"))
               (setq layers (append layers (list Name))))))
    (progn (vlax-map-collection
             (vla-get-layers #acadDoc)
             '(lambda (xx)
                (setq Name (vla-get-Name xx))
                (if (null (wcmatch Name "*$*"))
                  (setq layers (append layers (list Name))))))))
  layers)

(defun HideLayers  (namesON %cod %obb / %res %name xx sts selset l len)
  (setq #GlobLayers '())
  (vlax-for xx  (vla-get-layers #acadDoc)
    (setq %name (vla-get-Name xx))
    (if (null (wcmatch %name "*$*"))
      (progn (setq sts         (if (= (vla-get-LayerOn xx) :vlax-true)
                                 -1
                                 0)
                   #GlobLayers (append #GlobLayers (list (list %name sts))))
             (if (wcmatch %name namesON)
               (vla-put-LayerOn xx :vlax-true)
               (vla-put-LayerOn xx :vlax-false)))))
  (setq #GlobCodes '())
  (if (setq selset (ssget "_X" (list (cons 8 namesON))))
     (progn
       (setq len (sslength selset)
             l 0)
       (while (< l len)
         (if (/= (object->getCode (ssname selset l)) %cod)
           (progn
             (setq #GlobCodes (append #GlobCodes (list (ssname selset l))))
             (vla-put-visible (vlax-ename->vla-object (ssname selset l)) :vlax-false)))
         (setq l (1+ l))
       )  
     )
  )
  (vla-put-visible (vlax-ename->vla-object %obb) :vlax-true)
)  

(defun RestoreLayers  (/ xx %name %lays yy)
  (setq %lays (vla-get-layers #acadDoc))
  (foreach xx  #GlobLayers
    (setq %name (car xx)
          yy    (vla-item %lays %name))
    (if yy
      (if (= (cadr xx) -1)
        (vla-put-LayerOn yy :vlax-true)
        (vla-put-LayerOn yy :vlax-false))))
  (setq #GlobLayers nil)
  (foreach xx #GlobCodes
    (vla-put-visible (vlax-ename->vla-object xx) :vlax-true))
  (setq #GlobCodes nil)
  )

(defun wczytajLinetype  (LineType / Linetypes res Name)
  (setq res T)
  (if (and (/= LineType "") (/= LineType #cContinuous) (/= LineType "ByBlock") (/= LineType "ByLayer"))
    (progn (setq Linetypes (vla-get-Linetypes #acadDoc)
                 res       (get->item Linetypes LineType))
           (if (null res)
             (vla-Load Linetypes LineType "msg.lin"))
           (setq res (get->item Linetypes LineType))))
  res)

(defun aX-zoomCenter  (point)
   (arxZoomCenter point #magnification))

(defun aX-zoomCenterM  (point)
   (arxZoomCenter point (getvar #viewsize)))

(defun ename->vlaObj  (&object)
  (if (eq (type (eval &object)) 'ENAME)
    (set &object (vlax-ename->vla-object (eval &object)))))

(defun vlaObj->ename  (&object)
  (if (eq (type (eval &object)) 'VLA-OBJECT)
    (set &object (vlax-vla-object->ename (eval &object)))))

(defun listaPunktow->variantArray_3D  (lstPoints / arraySpace sArray ptsList)
  (setq ptsList '())
  (foreach &  lstPoints (setq ptsList (append (append (append ptsList (list (car &))) (list (cadr &))) (list (caddr &)))))
  (setq arraySpace (vlax-make-safearray vlax-vbDouble (cons 0 (- (length ptsList) 1)))) 
  (setq sArray (vlax-safearray-fill arraySpace ptsList))
  (vlax-make-variant sArray))

(defun listaPunktow->variantArray_2D  (lstPoints / arraySpace sArray ptsList)
  (setq ptsList '())
  (foreach & lstPoints (setq ptsList (append (append ptsList (list (car &))) (list (cadr &)))))
  (setq arraySpace (vlax-make-safearray vlax-vbDouble (cons 0 (- (length ptsList) 1))))
  (setq sArray (vlax-safearray-fill arraySpace ptsList))
  (vlax-make-variant sArray))

(defun vlaLista->3dpoint  (lista)
  (cond (lista (list (nth 0 lista) (nth 1 lista) (nth 2 lista)))
        (T nil)))

(defun vlaLista->3dPoints (Coordinates 2d / result item)
  (setq result '())
  (foreach & Coordinates
    (setq item (list (nth 0 &) (nth 1 &) (if 2d 0.0 (nth 2 &)))
          result (append result (list item))))
  result)

(defun Polyline->wierzcholki  (object / vts normal vtsR p)
  (if (= (type object) 'VLA-OBJECT)
    (setq object (vlax-vla-object->ename object)))
  (setq vts (arxGetCoords object)) 
  (if (vlax-property-available-p (vlax-ename->vla-object object) 'Normal)
    (progn
      (setq normal (vla-get-Normal (vlax-ename->vla-object object)))
      (if (minusp (caddr (vlax-safearray->list (vlax-variant-value normal))))
         (progn (setq vtsR '())
           (foreach &  vts
             (setq p (vla-TranslateCoordinates
                       (vla-get-utility #acadDoc)
                       (vlax-3d-point &)
                       acOCS
                       acWorld
                       :vlax-false
                       normal))
             (setq p (vlax-safearray->list (vlax-variant-value p)))            
             (setq vtsR (append vtsR (list p))))
           (setq vts vtsR)))))
    vts)    

(defun Polyline->wierzcholkiLuki  (object / vts normal vtsR p)
  (if (= (type object) 'VLA-OBJECT)
    (setq object (vlax-vla-object->ename object)))
  (setq vts (arxGetCoordsBulge object))
  (if (vlax-property-available-p (vlax-ename->vla-object object) 'Normal)
    (progn (setq normal (vla-get-Normal (vlax-ename->vla-object object)))
           (if (minusp (caddr (vlax-safearray->list (vlax-variant-value normal))))
             (progn (setq vtsR '())
                    (foreach &  vts
                      (setq p (vla-TranslateCoordinates
                                (vla-get-utility #acadDoc)
                                (vlax-3d-point (car &))
                                acOCS
                                acWorld
                                :vlax-false
                                normal))
                      (setq p (vlax-safearray->list (vlax-variant-value p)))
                      (setq vtsR (append vtsR (list (list p (- (cadr &)))))))
                    vtsR))))
  vts)

(defun vlaCreate3dPoly (wierzcholki cechy / object)
  (setq object (vla-Add3Dpoly #ModelS (listaPunktow->variantArray_3D wierzcholki)))
  (vlax->PutProperty object cechy)
  (vla-update object)
  object)

(defun vlaCreatePolyline  (wierzcholki cechy / object count makelist @@ blg wh)
  (cond (#Toolkit
         (setq makelist (list (cons 0 #cPOLYLINE)
                              '(8 . "0")
                              '(66 . 1)
                              '(10 0.0 0.0 0.0)
                              '(40 . 0.0)
                              '(41 . 0.0)
                              '(210 0.0 0.0 1.0)
                              '(71 . 0)
                              '(72 . 0)
                              '(73 . 0)
                              '(74 . 0)
                              '(75 . 0)))
         (entmake makelist)
         (foreach @@ wierzcholki
           (if (nth 3 @@)
             (setq blg (nth 3 @@))
             (setq blg 0.0))
           (if (nth 2 @@)
             (setq wh (nth 2 @@))
             (setq wh 0.0))
           (setq makelist (list (cons 0 #cVERTEX)
                                '(8 . "0")
                                (cons 10 (list (nth 0 @@) (nth 1 @@) wh))
                                '(40 . 0.0)
                                '(41 . 0.0)
                                (cons 42 blg)
                                '(70 . 0)
                                '(50 . 0.0)
                                '(71 . 0)
                                '(72 . 0)
                                '(73 . 0)
                                '(74 . 0)))
           (entmake makelist))
         (entmake (list (cons 0 #cSEQEND) '(8 . "0")))
         (setq object (vlax-ename->vla-object (entlast))))
        (T
         (setq object (vla-AddPolyline #ModelS (listaPunktow->variantArray_3D wierzcholki)))
         (setq count 0)
         (foreach &  wierzcholki
           (if (= (length &) 4)
             (vla-SetBulge object count (nth 3 &)))
           (setq count (1+ count)))))
  (setq cechy (append cechy (list (list 'LinetypeGeneration (getvar "PLINEGEN")))))
  (vlax->PutProperty object cechy)
  (vla-update object)
  object)      

(defun vlaMakePolylineArc  (lstWierz / makeList @@)
  (if (> (length lstWierz) 1)
    (progn (setq makelist (list (cons 0 #cPOLYLINE)
                                '(8 . "0")
                                '(66 . 1)
                                '(10 0.0 0.0 0.0)
                                '(40 . 0.0)
                                '(41 . 0.0)
                                '(210 0.0 0.0 1.0)
                                '(71 . 0)
                                '(72 . 0)
                                '(73 . 0)
                                '(74 . 0)
                                '(75 . 0))
                 )
           (entmake makelist)
           (foreach @@  lstWierz
             (setq makelist (list (cons 0 #cVERTEX)
                                  '(8 . "0")
                                  (cons 10 (car @@))
                                  '(40 . 0.0)
                                  '(41 . 0.0)
                                  (cons 42 (cadr @@))
                                  '(70 . 0)
                                  '(50 . 0.0)
                                  '(71 . 0)
                                  '(72 . 0)
                                  '(73 . 0)
                                  '(74 . 0))
                   )
             (entmake makelist))
           (entmake (list (cons 0 #cSEQEND) '(8 . "0")))
           (vlax-ename->vla-object (entlast)))
    nil)
  )

(defun vlaRedefinePolylineArc  (object wierzcholkiLuki / closed color layer linetype lineweight
                                thickness vlaObject newVlaObject)
  (setq vlaObject    (vlax-ename->vla-object object)
        newVlaObject (vlaMakePolylineArc wierzcholkiLuki))
  (vla-put-closed newVlaObject (vla-get-closed vlaObject))
  (vla-put-color newVlaObject (vla-get-color vlaObject))
  (vla-put-Elevation newVlaObject (vla-get-Elevation vlaObject))
  (vla-put-layer newVlaObject (vla-get-layer vlaObject))
  (vla-put-linetype newVlaObject (vla-get-linetype vlaObject))
  (vla-put-LinetypeGeneration newVlaObject (vla-get-LinetypeGeneration vlaObject))
  (vla-put-LinetypeScale newVlaObject (vla-get-LinetypeScale vlaObject))
  (vla-put-lineweight newVlaObject (vla-get-lineweight vlaObject))
  (vla-put-thickness newVlaObject (vla-get-thickness vlaObject))
  (vla-put-Visible newVlaObject (vla-get-Visible vlaObject))
  (vla-update newVlaObject)
  (change_link object (vlax-vla-object->ename newVlaObject))
  (entdel object)
  (vlax-vla-object->ename newVlaObject))

(defun vlaCopyPolyline  (object wierzcholki / closed color layer linetype lineweight thickness
                         vlaObject newVlaObject)
  (setq vlaObject    (vlax-ename->vla-object object)
        newVlaObject (vlaCreatePolyline
                       wierzcholki
                       (list (list 'Closed (vla-get-closed vlaObject))
                             (list 'Color (vla-get-color vlaObject))
                             (list 'Elevation (vla-get-Elevation vlaObject))
                             (list 'Layer (vla-get-layer vlaObject))
                             (list 'Linetype (vla-get-linetype vlaObject))
                             (list 'LinetypeGeneration (vla-get-LinetypeGeneration vlaObject))
                             (list 'LinetypeScale (vla-get-LinetypeScale vlaObject))
                             (list 'lineweight (vla-get-lineweight vlaObject))
                             (list 'thickness (vla-get-thickness vlaObject))
                             (list 'Visible (vla-get-Visible vlaObject)))))
  (change_link object (vlax-vla-object->ename newVlaObject))
  (entdel object)
  (vlax-vla-object->ename newVlaObject))

(defun Polyline->Mline  (obj ml / object newObj res vts)
  (setq res    obj
        object (ArxKanciok (casc 5 (entget obj)) 0.01 0))
  (if (/= object "")
    (progn (setq object (handent object)
                 vts (Polyline->wierzcholki object))
           (if (< (lista_powierzchnia vts) 0)
             (setq vts (reverse vts)))
           (setq res    (_createMlineSk
                          (casc 8 (entget object))
                          ml
                          (if (CheckClosedPolyline object)
                            1
                            0)
                          vts))
           (if res
             (progn (change_link object res) (entdel object))
             (setq res obj))))
  res)

(defun Mline->Polyline  (obj)
  (if (setq res (_createPolyline
                  (casc 8 (entget obj))
                  (if (checkClosedMline obj)
                    1
                    0)
                  (Mline->wierzcholki obj)))
    (progn (change_link obj res) (entdel obj))
    (setq res obj))
  res)

;;; Wstawia VERT za PA
(defun _PolylineInsertVert  (object pa vert / wierz w1 w2 vts ok toler xy)
  (setq toler 0.000001
        vts   (Polyline->wierzcholki object))
  (cond ((listp pa)
         (setq l     1
               wierz (list (car vts))
               ok    nil)
         (while (< l (length vts))
           (if (and (equal (_2d (nth (1- l) vts)) (_2d (car pa)) toler)
                    (equal (_2d (nth l vts)) (_2d (cadr pa)) toler))
             (setq wierz (append wierz (list vert))
                   ok    T))
           (setq wierz (append wierz (list (nth l vts))))
           (setq l (1+ l)))
         (if (null ok)
           (setq wierz (append wierz (list vert)))))
        (T
         (setq wierz '())
         (foreach xy  vts
           (setq wierz (append wierz (list xy)))
           (if (equal (_2d xy) (_2d pa) toler)
             (setq wierz (append wierz (list vert)))))))
  (vla-put-Coordinates (vlax-ename->vla-object object) (listaPunktow->variantArray_3D wierz)))

(defun get->item  (colection name / res xx)
  (setq res nil)
  (if #Toolkit
    (progn (vlax-for xx  colection
             (if (= (strcase name) (strcase (vla-get-Name xx)))
               (setq res xx))))
    (progn (vlax-map-collection
             colection
             '(lambda (xx)
                (if (= (strcase name) (strcase (vla-get-Name xx)))
                  (setq res xx))))))
  res)

(defun vlax->StyleExists (name / res)
  (get->item (vla-get-TextStyles #acadDoc) name))

(defun vlax->ReadStyles  (/ styles & Name)
  (setq styles '())
  (if #Toolkit
    (progn (vlax-for &  (vla-get-TextStyles #acadDoc)
             (setq Name (vla-get-Name &))
             (if (and (> (strlen Name) 0) (null (wcmatch Name "*$*")))
               (setq styles (append styles (list Name))))))
    (progn (vlax-map-collection
             (vla-get-TextStyles #acadDoc)
             '(lambda (&)
                (setq Name (vla-get-Name &))
                (if (and (> (strlen Name) 0) (null (wcmatch Name "*$*")))
                  (setq styles (append styles (list Name))))))))
  (vl-sort styles '<))

(defun vlax->DefiniujStyl  (Nazwa Font Cechy / styl)
  (if (null (vlax->StyleExists Nazwa))
    (progn (vl-cmdf "_-STYLE" Nazwa Font 0.0 1.0 0.0 "N" "N")
           (if (vlax->StyleExists Nazwa)
             (progn (setq styl (vla-item (vla-get-TextStyles #acadDoc) Nazwa))
                    (foreach & Cechy (vlax-put-property styl (car &) (cadr &)))))))
  (vlax->StyleExists Nazwa))

(defun vlax->ReadBloks  (/ bloks Name &)
  (setq bloks '())
  (if #Toolkit
    (progn (vlax-for &  (vla-get-Blocks #acadDoc)
             (setq Name (vla-get-Name &))
             (if (and (/= (substr Name 1 1) "*") (/= Name "xcmsgdef"))
               (setq bloks (append bloks (list Name))))))
    (progn (vlax-map-collection
             (vla-get-Blocks #acadDoc)
             '(lambda (&)
                (setq Name (vla-get-Name &))
                (if (and (/= (substr Name 1 1) "*") (/= Name "xcmsgdef"))
                  (setq bloks (append bloks (list Name))))))))
  (vl-sort bloks '<))

(defun vlax->GetAttrib  (obj aName / res &)
  (ename->vlaObj 'obj)
  (setq res nil)
  (if (arxHasAttributes (vlax-vla-object->ename obj))
    (foreach &  (vlax-safearray->list (vlax-variant-value (vla-GetAttributes obj)))
      (if (= (strcase aName) (strcase (vla-get-TagString &)))
        (setq res &))))
  res)

(defun vlax->RemoveAttrib  (oobb aaN / wyn)
  (if (setq wyn (vlax->GetAttrib oobb aaN))
    (vla-delete wyn)))

(defun vlax->PutAttribZ  (oobb aaN h / aa)
  (if (and h (distof h))
    (progn (ename->vlaObj 'oobb)
           (if (arxHasAttributes (vlax-vla-object->ename oobb))
             (foreach &  (vlax-safearray->list (vlax-variant-value (vla-GetAttributes oobb)))
               (if (= (strcase aaN) (strcase (vla-get-TagString &)))
                 (progn (setq aa (getTextInsertionPoint &))
                        (setq aa (list (car aa) (cadr aa) (distof h)))
                        (msg-vla-put-TextInsertionPoint & aa))))))))
                   
(defun TextPropByStyle  (obj / _styl vStyl)
  (arxReadTextStyles 1)
  (ename->vlaObj 'obj)
  (setq _styl (vla-get-StyleName obj)
         vStyl (vla-Item (vla-get-TextStyles #acadDoc) _styl))
  (vlax-put-property obj 'ObliqueAngle (vlax-get-property vStyl 'ObliqueAngle))
  (if (> (vlax-get-property vStyl 'Height) 0)
    (vlax-put-property obj 'Height (vlax-get-property vStyl 'Height)))
  (vlax-put-property obj 'ScaleFactor (vlax-get-property vStyl 'Width)))

(defun popupStrefaDow (str)
  (start_list str)
  (foreach _&_  #UkladyWsp
    (add_list _&_))
  (end_list))

(defun popupStrefa  ()
  (popupStrefaDow "strefa"))

(defun popup_skala(/ _&_)
  (start_list "skala")
  (foreach _&_ '("1:500" "1:1000" "1:2000" "1:5000" "1:10000")
    (add_list _&_))
  (end_list))

(defun skala_opracowania (/ _&_)
  (start_list "skala")
  (foreach _&_ '("1:500" "1:1000" "1:2000" "1:5000" "1:10000" "Inna")
    (add_list _&_))
  (end_list))

(defun rsort (/ _&_)
  (start_list "renum")
  (foreach _&_ '("> Numer" "> X" "> Y" "< Numer" "< X" "< Y")
    (add_list _&_))
  (end_list))

(defun sort_maskDz (/ _&_)
  (start_list "sort")
  (foreach _&_ '("Numeru" ;|"Karty mapy"|; "Powierzchni")
    (add_list _&_))
  (end_list))

(defun sort_maskKl (/ _&_)
  (start_list "sort")
  (foreach _&_ '("Numeru" "Oznaczenia" "Powierzchni")
    (add_list _&_))
  (end_list))

(defun CreatedByMapa_SG (/ res dict)
  (setq res nil)
  (if (setq dict (vla-get-Dictionaries #acadDoc))
    (vlax-for & dict
      (if (vlax-property-available-p & 'Name)
        (if (= (vla-get-Name &) "MapaSG11")
           (setq res &)))))
  res)

(defun AddWipeout  (Verts obj / nor dxf10 max_dist cen dxf14 entl res &)
  (if (null obj)
    (setq nor (list 0.0 0.0 1.0))
    (setq nor (cdr (assoc 210 (entget obj)))))
  (setq entl (entlast))
  (setq dxf10    (list (apply 'min (mapcar 'car Verts)) (apply 'min (mapcar 'cadr Verts)) (caddar Verts))
        max_dist (float (apply 'max (mapcar '- (apply 'mapcar (cons 'max Verts)) dxf10)))
        cen      (mapcar '+ dxf10 (list (/ max_dist 2) (/ max_dist 2) 0.0))
        dxf14    (mapcar '(lambda (p) (mapcar '/ (mapcar '- p cen) (list max_dist (- max_dist) 1.0))) Verts)
        dxf14    (reverse (cons (car dxf14) (reverse dxf14))))
  (entmake (append (list (cons 0 #cWIPEOUT)
                         '(100 . "AcDbEntity")
                         '(100 . "AcDbWipeout")
                         '(90 . 0)
                         (cons 10 (trans dxf10 nor 0))
                         (cons 11 (trans (list max_dist 0.0 0.0) nor 0))
                         (cons 12 (trans (list 0.0 max_dist 0.0) nor 0))
                         '(13 1.0 1.0 0.0)
                         '(70 . 7)
                         '(280 . 1)
                         '(71 . 2)
                         (cons 91 (length dxf14)))
                   (mapcar '(lambda (p) (cons 14 p)) dxf14)))
  (setq res (entlast))
  (if (and (not (eq res entl)) (= (casc 0 (entget res)) #cWIPEOUT))
    res
    nil))

(defun SetAttByName  (vBlock attName attValue)
  (if (arxHasAttributes (vlax-vla-object->ename vBlock))
    (foreach &  (vlax-safearray->list (vlax-variant-value (vla-GetAttributes vBlock)))
      (if (= (strcase attName) (strcase (vla-get-TagString &)))
        (vla-put-TextString & attValue)))))

(defun putCoordinates  (obb Verts / lpp i)
  (if (= (casc 0 (entget obb)) #cLWPOLYLINE)
    (setq lpp (listaPunktow->variantArray_2D Verts)
          i   2)
    (setq lpp (listaPunktow->variantArray_3D Verts)
          i   3))
  (if #GSTAR2016
    (progn (arxPlineVert obb (length Verts))))
  (vla-put-Coordinates (vlax-ename->vla-object obb) lpp)
  (if (vlax-property-available-p (vlax-ename->vla-object obb) 'ConstantWidth)
    (vla-put-ConstantWidth (vlax-ename->vla-object obb) 0.0))
  (vla-update (vlax-ename->vla-object obb)))

